/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.gui.actions.shells.control;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;

public class TileWindowsActionListener
implements ActionListener {
    private JDesktopPane desktopPane;
    private boolean horizontal;

    public TileWindowsActionListener(JDesktopPane p, boolean h) {
        this.desktopPane = p;
        this.horizontal = h;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JInternalFrame[] frames = this.desktopPane.getAllFrames();
        if (frames.length == 0) {
            return;
        }
        this.tileWindows();
    }

    private void tileWindows() {
        JInternalFrame[] frames = this.desktopPane.getAllFrames();
        Dimension frameSize = new Dimension(this.desktopPane.getSize());
        int xShift = 0;
        int yShift = 0;
        if (frames.length > 0) {
            if (this.horizontal) {
                frameSize.height /= frames.length;
                yShift = frameSize.height;
            } else {
                frameSize.width /= frames.length;
                xShift = frameSize.width;
            }
        }
        int x = 0;
        int y = 0;
        for (int i = 0; i < frames.length; ++i) {
            if (frames[i].isMaximum()) {
                try {
                    frames[i].setMaximum(false);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
            frames[i].setSize(frameSize);
            frames[i].setLocation(x, y);
            x += xShift;
            y += yShift;
        }
    }
}

